global files "C:/Users/WB326023/Dropbox/WB/BPEA/BPEA Replication/"
global BPEAraw "$files/dataraw"
global BPEAout "$files/dataout"
global BPEAtemp "$files/temp"
global BPEAplots "$files/plots"


/*---------------------------------------
Graph
---------------------------------------*/

loc run = 1
if `run' == 1{
/*
preserve
import delimited "$BPEAout/panjiva/usimportstotal.csv", clear 	
rename v1 tnum	
collapse (sum) realimports, by(tnum)
drop if tnum==.
sort tnum
replace realimports = realimports/1000
tempfile import
save `import'
restore
	
use  "$BPEAout/panjiva/suppliers.dta", clear

collapse (mean) separationrate* entryrate* netseparationrate*, by(tnum)

merge 1:1 tnum using `import'
drop _m

save "$BPEAout/panjiva/panjiva_graph.dta", replace*/

use "$BPEAout/panjiva/panjiva_graph.dta", clear


twoway (line entryrate tnum if tnum>1 & tnum<16, lcolor(green) lpattern(solid) yaxis(2)) ///
	   (line separationrate  tnum if tnum>1 & tnum<16, lcolor(blue) lpattern(solid) yaxis(2)) ///
	   (line realimports tnum if tnum>1 & tnum<16, lcolor(black) yaxis(1) lpattern(dash_dot)), ///
 ytitle("", axis(1))  xtitle("") subtitle("U.S. firms' relationships with international suppliers", color(black)) ///
legend(nobox label(1 "Entry rate (left axis)")  label(2 "Separation rate (left axis)")  label(3 "Total import value (right axis)")  pos(1) region(lpattern(blank)))  ///
graphregion( color(white)) bgcolor(white) ///
ytitle("US$ billions, 2018 prices", axis(1)) ytitle("Percent", axis(2)) ///
xline(6, lpattern(solid) lcolor(red)) xscale(range(1/16)) ///
xlabel(2 "dec18feb19" 3 "marmay19" 4 "junaug19" 5 "sepnov19" ///
       6 "dec19feb20" 7 "marmay20" 8 "junaug20"  9 "sepnov20"  ///
       10 "dec20feb21" 11 "marmay21" 12 "junaug21"  13 "sepnov21" ///
       14 "dec21feb22" 15 "marmay22" , angle(45))
	   
graph export "$BPEAplots\US_separation_entry_v1.pdf", replace

graph export "$BPEAplots\US_separation_entry_v1.png", replace


}

